% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_model_OrdOrd_copula.R
\name{ordinal_ordinal_loglik}
\alias{ordinal_ordinal_loglik}
\title{Loglikelihood function for ordinal-ordinal copula model}
\usage{
ordinal_ordinal_loglik(para, X, Y, copula_family, K_X, K_Y, return_sum = TRUE)
}
\arguments{
\item{para}{Parameter vector. The parameters are ordered as follows:
\itemize{
\item \code{para[1:p1]}: Cutpoints for the latent distribution of X corresponding to
\eqn{c_1^X, \dots, c_{K_X - 1}^X} (see Details).
\item \code{para[(p1 + 1):(p1 + p2)]}: Cutpoints for the latent distribution of Y corresponding to
\eqn{c_1^Y, \dots, c_{K_Y - 1}^Y} (see Details).
\item \code{para[p1 + p2 + 1]}: copula parameter
}}

\item{X}{First variable (Ordinal with \eqn{K_X} categories)}

\item{Y}{Second variable (Ordinal with \eqn{K_Y} categories)}

\item{copula_family}{Copula family, one of the following:
\itemize{
\item \code{"clayton"}
\item \code{"frank"}
\item \code{"gumbel"}
\item \code{"gaussian"}
}}

\item{K_X}{Number of categories in \code{X}.}

\item{K_Y}{Number of categories in \code{Y}.}

\item{return_sum}{Return the sum of the individual loglikelihoods? If \code{FALSE},
a vector with the individual loglikelihood contributions is returned.}
}
\value{
(numeric) loglikelihood value evaluated in \code{para}.
}
\description{
\code{\link[=ordinal_ordinal_loglik]{ordinal_ordinal_loglik()}} computes the observed-data loglikelihood for a
bivariate copula model with two ordinal endpoints. The model
is based on a latent variable representation of the ordinal endpoints.
}
\details{
\subsection{Vine Copula Model for Ordinal Endpoints}{

Following the Neyman-Rubin potential outcomes framework, we assume that each
patient has four potential outcomes, two for each arm, represented by
\eqn{\boldsymbol{Y} = (T_0, S_0, S_1, T_1)'}. Here, \eqn{\boldsymbol{Y_z} =
(S_z, T_z)'} are the potential surrogate and true endpoints under treatment
\eqn{Z = z}.

The latent variable notation and D-vine copula model for \eqn{\boldsymbol{Y}}
is a straightforward extension of the notation in
\code{\link[=ordinal_continuous_loglik]{ordinal_continuous_loglik()}}.
}

\subsection{Observed-Data Likelihood}{

In practice, we only observe \eqn{(S_0, T_0)'} or \eqn{(S_1, T_1)'}. Hence, to
estimate the (identifiable) parameters of the D-vine copula model, we need
to derive the observed-data likelihood. The observed-data loglikelihood for
\eqn{(S_z, T_z)'} is as follows:
\deqn{
f_{\boldsymbol{Y_z}}(s, t; \boldsymbol{\beta}) =
P \left( c^{S_z}_{s - 1} < \tilde{S}_z, c^{T_z}_{t - 1} < \tilde{T}_z  \right) - P \left( c^{S_z}_{s} < \tilde{S}_z, c^{T_z}_{t - 1} < \tilde{T}_z  \right)
- P \left( c^{S_z}_{s - 1} < \tilde{S}_z, c^{T_z}_{t} < \tilde{T}_z  \right) + P \left( c^{S_z}_{s} < \tilde{S}_z, c^{T_z}_{t} < \tilde{T}_z  \right).
}
The above expression is used in \code{\link[=ordinal_ordinal_loglik]{ordinal_ordinal_loglik()}} to compute the
loglikelihood for the observed values for \eqn{Z = 0} or \eqn{Z = 1}.
}
}
