% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cleaning.R
\name{clean_missing}
\alias{clean_missing}
\title{Clean missing values in specified column}
\usage{
clean_missing(data, col, method = c("mean", "median", "mode"))
}
\arguments{
\item{data}{A data.frame containing survey data}

\item{col}{Character string specifying column name to clean}

\item{method}{Character string specifying imputation method ("mean", "median", or "mode")}
}
\value{
A data.frame with missing values imputed
}
\description{
This function handles missing values using specified imputation method.
Supports mean, median, and mode imputation for numeric variables.
}
\examples{
data <- data.frame(age = c(25, NA, 30, NA, 35))
clean_data <- clean_missing(data, "age", method = "mean")
}
