% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{creatinine_serum}
\alias{creatinine_serum}
\title{Serum Creatinine Method Comparison Dataset}
\format{
A data frame with 80 observations and 3 variables:
\describe{
\item{sample_id}{Character. Unique sample identifier.}
\item{enzymatic}{Numeric. Creatinine concentration (mg/dL) measured by
the enzymatic method.}
\item{jaffe}{Numeric. Creatinine concentration (mg/dL) measured by the
Jaffe method.}
}
}
\source{
Synthetic data generated to mimic realistic clinical patterns. See
\code{data-raw/make_datasets.R} for the generation script.
}
\usage{
creatinine_serum
}
\description{
Synthetic dataset comparing serum creatinine measurements from two analytical
methods: an enzymatic method (reference) and the Jaffe colorimetric method.
This is a classic method comparison scenario where the Jaffe method is known
to have positive interference from proteins and other chromogens.
}
\details{
This synthetic dataset was designed to illustrate well-known patterns in
creatinine method comparisons:

\itemize{
\item \strong{Concentration range}: 0.4-8.0 mg/dL, from normal kidney function
to severe chronic kidney disease (CKD)
\item \strong{Bias pattern}: Jaffe method shows positive bias, more pronounced
at lower concentrations due to pseudocreatinine interference
\item \strong{Outliers}: A few samples show larger positive bias, simulating
interference from bilirubin, hemolysis, or ketones
}

The enzymatic method is more specific and has largely replaced the Jaffe
method in modern clinical laboratories, though the Jaffe method remains in
use in some settings due to lower reagent costs.
}
\examples{
# Bland-Altman analysis
ba <- ba_analysis(enzymatic ~ jaffe, data = creatinine_serum)
summary(ba)
plot(ba)

# Note: Jaffe typically shows positive bias vs enzymatic

}
\references{
Peake M, Whiting M. Measurement of serum creatinine--current status and
future goals. Clin Biochem Rev. 2006;27(4):173-184.
}
\seealso{
\code{\link[=ba_analysis]{ba_analysis()}}, \link{glucose_methods}, \link{troponin_cardiac}
}
\keyword{datasets}
