% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_genSMILEY.R
\name{genSMILEY}
\alias{genSMILEY}
\title{Generate SMILEY Data}
\usage{
genSMILEY(n = 496, sd = 0.1)
}
\arguments{
\item{n}{number of samples to be generated.}

\item{sd}{additive Gaussian noise level.}
}
\value{
a list containing\describe{
\item{data}{an \eqn{(n\times 2)} data matrix.}
\item{label}{a length-\eqn{n} vector(factor) for class labels.}
}
}
\description{
Creates a smiley-face data in \eqn{\mathbf{R}^2}. This function is a modification 
of \pkg{mlbench}'s \code{mlbench.smiley} function.
}
\examples{
\donttest{
## Generate SMILEY Data with Difference Noise Levels
s10 = genSMILEY(200, sd=0.1)
s25 = genSMILEY(200, sd=0.25)
s50 = genSMILEY(200, sd=0.5)

## Visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3), pty="s")
plot(s10$data, col=s10$label, pch=19, main="sd=0.10")
plot(s25$data, col=s25$label, pch=19, main="sd=0.25")
plot(s50$data, col=s50$label, pch=19, main="sd=0.50")
par(opar)
}

}
\concept{data}
