% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image_bary.R
\name{imagebary}
\alias{imagebary}
\title{Barycenter of Images}
\usage{
imagebary(images, p = 2, weights = NULL, C = NULL, ...)
}
\arguments{
\item{images}{a length-\eqn{N} list of same-size image matrices of size \eqn{(m\times n)}.}

\item{p}{an exponent for the order of the distance (default: 2). Currently, only \code{p=2}
is supported (squared ground distance cost).}

\item{weights}{a weight of each image; if \code{NULL} (default), uniform weight is set.
Otherwise, it should be a length-\eqn{N} vector of nonnegative weights.}

\item{C}{an optional \eqn{(mn\times mn)} ground cost matrix. If \code{NULL} (default), the
squared Euclidean grid cost is used. Providing \code{C} allows using alternative ground
costs (e.g., geodesic distances on a manifold discretization).}

\item{...}{extra parameters including \describe{
\item{abstol}{stopping criterion based on \eqn{\ell_2} change of iterates (default: \code{1e-7}).}
\item{init.image}{an initial barycenter image (default: arithmetic mean of normalized inputs).}
\item{maxiter}{maximum number of mirror descent iterations (default: \code{200}).}
\item{step0}{initial stepsize for mirror descent (default: \code{0.5}).}
\item{stepschedule}{stepsize schedule; \code{"sqrt"} uses \eqn{\eta_t=\text{step0}/\sqrt{t}},
  and \code{"const"} uses \eqn{\eta_t=\text{step0}} (default: \code{"sqrt"}).}
\item{eps}{positivity floor for the barycenter and inputs; values are truncated below \code{eps}
  and renormalized (default: \code{1e-15}). Larger values can improve robustness.}
\item{smooth}{optional mixing weight toward uniform distribution after each update, used to
  prevent near-zero support that may cause OT infeasibility (default: \code{1e-12}). Set to
  \code{0} to disable.}
\item{clip}{\eqn{\ell_\infty} clipping threshold for the subgradient to stabilize exponentials
  in the KL update (default: \code{50}). Set to \code{Inf} to disable.}
\item{max_backtrack}{maximum number of backtracking halvings of the stepsize when an OT probe
  fails at the proposed update (default: \code{8}).}
\item{print.progress}{a logical to show iteration diagnostics (default: \code{FALSE}).}
}}
}
\value{
an \eqn{(m\times n)} matrix of the barycentric image.
}
\description{
Using exact balanced optimal transport as a subroutine,
\code{imagebary} computes an unregularized 2-Wasserstein barycenter image
\eqn{X^\star} from multiple input images \eqn{X_1,\ldots,X_N}. 
Unlike the other image barycenter routines, this function does not use 
entropic regularization. Instead, it solves the barycenter problem with a 
robust first-order method based on mirror descent on the probability simplex.
}
\details{
The algorithm treats each image as a discrete probability distribution on a
common \eqn{(m\times n)} grid. At each iteration, it computes exact OT dual
potentials \eqn{u_i} between the current barycenter iterate and each input
image via \code{util_dual_emd_C}. These dual potentials form a valid subgradient
of the barycenter objective, and a KL-mirror descent step produces a strictly
positive update of the barycenter weights. For numerical stability, the
implementation includes (i) centering of dual potentials (shift invariance),
(ii) gradient clipping, (iii) log-domain normalization, and (iv) optional
smoothing/backtracking safeguards to avoid infeasible OT calls.
}
\examples{
\dontrun{
#----------------------------------------------------------------------
#                       MNIST Data with Digit 3
#
# small example to compare the un- and regularized problem solutions
# choose only 10 images and run for 20 iterations with default penalties
#----------------------------------------------------------------------
# LOAD DATA
set.seed(11)
data(digit3)
dat_small = digit3[sample(1:2000, 10)]

# RUN
run_exact = imagebary(dat_small, maxiter=20)
run_reg14 = imagebary14C(dat_small, maxiter=20)
run_reg15 = imagebary15B(dat_small, maxiter=20)

# VISUALIZE
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3), pty="s")
image(run_exact, axes=FALSE, main="Unregularized")
image(run_reg14, axes=FALSE, main="Cuturi & Doucet (2014)")
image(run_reg15, axes=FALSE, main="Benamou et al. (2015)")
par(opar)
}

}
\concept{image}
