% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image_interp.R
\name{imageinterp}
\alias{imageinterp}
\title{Interpolation between Images}
\usage{
imageinterp(image1, image2, t = 0.5, ...)
}
\arguments{
\item{image1}{a grayscale image matrix of size \eqn{(m\times n)} with nonnegative entries.}

\item{image2}{another grayscale image matrix of size \eqn{(m\times n)} with nonnegative entries.}

\item{t}{a scalar or numeric vector in \eqn{[0,1]} specifying interpolation times.
\code{t=0} returns \code{image1}, \code{t=1} returns \code{image2}.}

\item{...}{extra parameters including \describe{
\item{eps}{positivity floor applied after normalization (default: \code{1e-15}).
  Larger values can improve robustness.}
\item{abstol}{tolerance used for internal mass checks (default: \code{1e-12}).}
\item{print.progress}{logical; if \code{TRUE}, print basic diagnostics (default: \code{FALSE}).}
}}
}
\value{
If \code{length(t)==1}, a single \eqn{(m\times n)} matrix representing the interpolated image.
If \code{length(t)>1}, a length-\code{length(t)} list of \eqn{(m\times n)} matrices.
}
\description{
Given two grayscale images represented as numeric matrices of identical size,
compute interpolated images along a 2-Wasserstein geodesic connecting them.
The function interprets each image as a discrete probability distribution on
a common \eqn{(m\times n)} grid, computes an exact optimal transport plan, 
and constructs intermediate measures by pushing the
plan through the linear interpolation map \eqn{z=(1-t)x+t y} (displacement
interpolation / McCann's interpolation).
}
\details{
Because the interpolated support locations generally do not coincide with
the original grid points, the resulting distribution is projected back onto
the grid by depositing transported mass to the nearest grid location. 
This is a simple and robust "re-binning" step, analogous in spirit to how 
\code{histinterp} re-bins interpolated quantile samples.
}
\examples{
\donttest{
#----------------------------------------------------------------------
#                  Digit Interpolation between 1 and 8
#----------------------------------------------------------------------
# LOAD DATA
set.seed(11)
data(digits)
x1 <- digits$image[[sample(which(digits$label==1),1)]] 
x2 <- digits$image[[sample(which(digits$label==8),1)]]

# COMPUTE
tvec <- seq(0, 1, length.out=10)
path <- imageinterp(x1, x2, t = tvec)

# VISUALIZE
opar <- par(no.readonly=TRUE)
par(mfrow=c(2,5), pty="s")
for (k in 1:10){
  image(path[[k]], axes=FALSE, main=sprintf("t=\%.2f", tvec[k]))
} 
par(opar)
}

}
\concept{image}
