% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inference.R
\name{phom.dist}
\alias{phom.dist}
\title{Calculate Distance between Homology Matrices}
\usage{
phom.dist(phom1, phom2, limit.num = 0)
}
\arguments{
\item{phom1}{3-by-n numeric matrix containing persistent homology for first dataset}

\item{phom2}{3-by-n numeric matrix containing persistent homology for second dataset}

\item{limit.num}{limit comparison to only top `limit.num` features in each dimension}
}
\value{
distance vector (1 element per dimension) between `phom1` and `phom2`
}
\description{
Calculates the distance between two matrices containing persistent homology
features, usually as returned by the `calculate_homology` function.
}
\details{
Note that the absolute value of this measure of distance is not meaningful
without a null distribution or at least another value for relative
comparison (e.g. finding most similar pair within a triplet).
}
