% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/memoMDB.R
\name{memoMDB}
\alias{memoMDB}
\alias{names<-.memoMDB}
\alias{rename.memoMDB}
\alias{[.memoMDB}
\alias{[[.memoMDB}
\alias{$.memoMDB}
\title{An \link{MDB} (Modeled DataBase) in memory: memoMDB}
\usage{
memoMDB(
  dataTables,
  dataModel,
  dbInfo,
  collectionMembers = NULL,
  check = TRUE,
  checks = c("unique", "not nullable", "foreign keys"),
  verbose = FALSE
)

\method{names}{memoMDB}(x) <- value

\method{rename}{memoMDB}(.data, ...)

\method{[}{memoMDB}(x, i)

\method{[[}{memoMDB}(x, i)

\method{$}{memoMDB}(x, i)
}
\arguments{
\item{dataTables}{a list of tibbles}

\item{dataModel}{a \link[ReDaMoR:RelDataModel]{ReDaMoR::RelDataModel} object}

\item{dbInfo}{a list with DB information:
\strong{"name"} (only mandatory field), "title", "description", "url",
"version", "maintainer".}

\item{collectionMembers}{the members of collections as provided to the
\link{collection_members<-} function (default: NULL ==> no member).}

\item{check}{logical: if TRUE (default) the data are confronted to the
data model}

\item{checks}{a character vector with the name of optional checks to be
done (all of them c("unique", "not nullable", "foreign keys"))}

\item{verbose}{if TRUE display the data confrontation report
(default: FALSE)}

\item{x}{a \link{memoMDB} object}

\item{value}{new table names}

\item{.data}{a \link{memoMDB} object}

\item{...}{Use new_name = old_name to rename selected tables}

\item{i}{the index or the name of the tables to take}
}
\value{
A memoMDB object
}
\description{
An \link{MDB} (Modeled DataBase) in memory: memoMDB

Rename tables of a \link{memoMDB} object
}
\examples{
hpo <- read_fileMDB(
   path=system.file("examples/HPO-subset", package="ReDaMoR"),
   dataModel=system.file("examples/HPO-model.json", package="ReDaMoR"),
   dbInfo=list(
      "name"="HPO",
      "title"="Data extracted from the HPO database",
      "description"=paste(
         "This is a very small subset of the HPO!",
         "Visit the reference URL for more information"
      ),
      "url"="http://human-phenotype-ontology.github.io/"
   )
) \%>\% 
   as_memoMDB()
count_records(hpo)

## Too long on win-builder.r-project.org
\dontrun{
   
hpoSlice <- slice(hpo, HPO_diseases=1:10)
count_records(hpoSlice)

if("stringr" \%in\% installed.packages()[,"Package"]){
   epilHP <- filter(
      hpo,
      HPO_diseases=stringr::str_detect(
         label, stringr::regex("epilepsy", ignore_case=TRUE)
      )
   )
   count_records(epilHP)
}

}
}
\seealso{
\itemize{
\item MDB methods:
\link{db_info}, \link{data_model}, \link{data_tables}, \link{collection_members},
\link{count_records}, \link{dims}, \link{filter_with_tables}, \link{as_fileMDB}
\item Additional general documentation is related to \link{MDB}.
\item \link{filter.memoMDB}, \link{slice.memoMDB}
}
}
