% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normaliz.R
\name{normalize}
\alias{normalize}
\alias{normaliz.vector}
\alias{normaliz.vectors}
\alias{normaliz.polytope}
\alias{normaliz.ultrametrics}
\title{Normalize a point or set of points in the tropical projective torus}
\usage{
normaliz.vector(D)

normaliz.vectors(D)

normaliz.polytope(D)

normaliz.ultrametrics(D)
}
\arguments{
\item{D}{numeric vector in the tropical projective torus or a matrix of
points in the tropical projective torus; for matrices, rows are the points}
}
\value{
a single or set of normalized points with the first coordinate zero
}
\description{
This function normalizes a point or set of points in the tropical projective
torus by making the first coordinate zero
}
\examples{
D <-c(8,4,2)
normaliz.vector(D)

P <-matrix(c(8,4,2,10,1,3,7,2,1),3,3,TRUE)
normaliz.vectors(P)

M<-matrix(c(2,2,2,3,6,4,2,4,7),3,3,TRUE)
normaliz.polytope(M)

M <- Sim_Trees15[1:3,]
normaliz.ultrametrics(M)

}
\author{
Ruriko Yoshida \email{ryoshida@nps.edu}
}
