% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tdc.R
\name{tdc}
\alias{tdc}
\title{Temporal degree centrality}
\usage{
tdc(x, type = NULL, startsnapshot = 1, endsnapshot = length(x),
  directed = FALSE, normalize = TRUE, centrality_evolution = FALSE)
}
\arguments{
\item{x}{A list of adjacency matrices or a list of adjacency lists.}

\item{type}{Data format of \code{x}. Possible formats are \code{"M"} for a
list of adjacency matrices (containing only 1s and 0s) and \code{"L"} for a
list of adjacency lists (adjacency lists of the igraph package are
supported). Default is \code{NULL}.}

\item{startsnapshot}{Numeric. Entry of \code{x} to start the calculation of
\code{tdc}. Default is 1.}

\item{endsnapshot}{Numeric. Entry of \code{x} to end the calculation of
\code{tdc}. Default is the last element of \code{x}.}

\item{directed}{Logical. Set \code{TRUE} if the temporal network is a
directed network. Default is \code{FALSE}.}

\item{normalize}{Logical. Set \code{TRUE} if centrality values should be
normalized with \eqn{1/((|V|-1)*m)} where \eqn{|V|} is the number of nodes
and \eqn{m =} \code{endsnapshot} \eqn{-} \code{startsnapshot}. Default is
\code{TRUE}.}

\item{centrality_evolution}{Logical. Set \code{TRUE} if an additional matrix
should be returned containing the centrality values at each snapshot. Rows
correspondent to nodes, columns correspondent to snapshots. Default
is \code{FALSE}.}
}
\value{
The (normalized) temporal degree centrality values of all nodes
  (\code{TDC}). If \code{centrality_evolution} is \code{TRUE} an additional
  matrix is returned (\code{CentEvo}), containing the temporal centrality
  value at each snapshot between \code{startsnapshot} and \code{endsnapshot}.
}
\description{
\code{tdc} returns the temporal degree centrality for each node in a dynamic
network (sequence of graph snapshots).
}
\details{
\code{tdc} calculates the temporal degree centrality (see Kim and
  Anderson, 2012), which is defined as the average degree centrality over all
  snapshots.
}
\section{Warning}{
 Using adjacency matrices as input exponentially increases
  the required memory. Use adjacency lists to save memory.
}

\examples{
# Create a list of adjacency matrices, plot the corresponding graphs
# (using the igraph package) and calculating tdc

A1 <- matrix(c(0,1,0,0,0,0,
               1,0,1,0,0,0,
               0,1,0,0,0,0,
               0,0,0,0,0,0,
               0,0,0,0,0,0,
               0,0,0,0,0,0), ncol=6)

A2 <- matrix(c(0,0,0,0,0,0,
               0,0,1,0,0,0,
               0,1,0,1,1,0,
               0,0,1,0,0,0,
               0,0,1,0,0,0,
               0,0,0,0,0,0), ncol=6)

A3 <- matrix(c(0,0,0,0,0,0,
               0,0,0,0,0,0,
               0,0,0,0,0,0,
               0,0,0,0,0,0,
               0,0,0,0,0,0,
               0,0,0,0,0,0), ncol=6)

A4 <- matrix(c(0,1,0,0,0,0,
               1,0,0,1,0,0,
               0,0,0,0,0,0,
               0,1,0,0,0,0,
               0,0,0,0,0,0,
               0,0,0,0,0,0), ncol=6)

library(igraph)
par(mfrow=c(2,2))

Layout <-
 layout_in_circle(graph_from_adjacency_matrix(A1, mode = "undirected"))

plot(graph_from_adjacency_matrix(A1, "undirected"), layout=Layout)
plot(graph_from_adjacency_matrix(A2, "undirected"), layout=Layout)
plot(graph_from_adjacency_matrix(A3, "undirected"), layout=Layout)
plot(graph_from_adjacency_matrix(A4, "undirected"), layout=Layout)

As <- list(A1,A2,A3,A4)

tdc(As, "M", centrality_evolution=TRUE)

#' ### Create list of adjacency lists
Ls <- lapply(seq_along(As), function(i){
  sapply(1:6, function(j){which(As[[i]][j,]==1)})
})

tdc(Ls, "L", centrality_evolution=TRUE)

}
\references{
Kim, Hyoungshick and Anderson, Ross, 2012. \emph{Temporal node
  centrality in complex networks}. Physical Review E, 85 (2).
}
\seealso{
\code{\link{tbc},\link{tcc}}
}
