% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/franckCO2.R
\name{franksCO2}
\alias{franksCO2}
\title{Franks CO2 Vegetation correction}
\usage{
franksCO2(CTSR.VI, C4frac, CO2 = FALSE, refyear = 1980)
}
\arguments{
\item{CTSR.VI}{Complete Monthly Time Series of Vegetation Index values.
An object of class \code{'ts'} object without NA's.}

\item{C4frac}{The fraction of vegetation that follows the C4 photosynthetic pathway, between 0 and 1}

\item{CO2}{A timeseries containg the CO2 concentration. The defualt is CMIP5 RCP8.5}

\item{refyear}{The Year that acts as a baseline for CO2. All vegetation values will be scaled #
to the CO2 concentration of this year. Defulat is 1980. THis function will pick the
first value in the selected year,}
}
\value{
\bold{CTSR.VIadj}
       A version of the CTSR.VI data that has been adjusted to account for CO2
}
\description{
Adjusts a vegetation time series to account for CO2 fertilisation
}
\author{
Arden Burrell, aburrell@whrc.org
}
