#' @title Get coalition number
#' @description This function returns the binary order position of the coalition formed by the given players.
#' @param S The players forming the coalition, as a vector.
#' @return The binary order position of the coalition formed by the given players.
#' @details A coalition \eqn{S\in 2^N} can be represented by the \eqn{n}-digit binary number \eqn{s_1\dots s_n} where \eqn{s_i=1} if \eqn{i\in S} and \eqn{0} otherwise. The binary order position of a coalition \eqn{S\in 2^N} is given by  \eqn{\sum_{i\in S} 2^{i-1}}.
#' @examples
#' N <- c(1:5)
#' S <- c(1, 2, 3)
#' getcoalitionnumber(S)
#' n <- length(N) # number of players
#' NS <- setdiff(N,S) # complementary coalition
#' getcoalitionnumber(S) + getcoalitionnumber(NS) == 2^n - 1
#' @seealso \link{codebin2lex}, \link{codelex2bin}, \link{getcoalition}
#' @export

getcoalitionnumber <- function(S) { # Principio de la función

  if (sum(S <= 0) > 0 || sum(S != round(S)) > 0) {
    stop("'S' must be a vector of positive integers.")
  }

  S <- unique(S) # eliminamos los jugadores repetidos

  # 2.^(S-1) devuelve la posición de cada jugador en orden binario.
  # Sumando esas cantidades, obtenemos el número de la coalición.
  num <- sum(2.^(S - 1))

  return(num)

}
