% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pre_eigenplot.R
\name{pre_eigenplot}
\alias{pre_eigenplot}
\title{Eigenvalue Plot of a Random Sample}
\usage{
pre_eigenplot(X, k)
}
\arguments{
\item{X}{A 'Tensor' object defined in package \pkg{rTensor} with \eqn{K+1} modes. Mode-1 should correspond to the time mode.}

\item{k}{The mode to plot the eigenvalues for.}
}
\description{
Function to plot the eigenvalues of the sample covariance matrix of a randomly chosen sample.
}
\details{
Input a tensor time series and a mode index, output the plot of eigenvalues of the sample covariance matrix of the given mode,
with a randomly chosen sample of the mode-\eqn{k} fibres. This helps users to choose the parameter \code{eigen_j} in function \code{pre_est}.
A large dip should be observed at the (\eqn{r_k+1})-th position of the plot,
and user can choose \code{eigen_j} to be a bit larger than the position of dip observed to avoid missing potential weak factors. If such a dip
is not observed, try to run the function for a few times until it can be observed.
}
\examples{
# Example of a real data set
set.seed(800)
pre_eigenplot(value_weight_tensor, k = 2)

\donttest{
# Example using generated data
K = 2
T = 100
d = c(40,40)
r = c(2,2)
re = c(2,2)
eta = list(c(0,0),c(0,0))
u = list(c(-2,2),c(-2,2))
set.seed(10)
Data_test = tensor_data_gen(K,T,d,r,re,eta,u)
X = Data_test$X
pre_eigenplot(X, k = 1)
}
}
