% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shadowtest_functions.R
\name{assembleShadowTest}
\alias{assembleShadowTest}
\title{(Internal) Assemble a shadowtest}
\usage{
assembleShadowTest(
  j,
  position,
  o,
  eligibility_flag,
  exclude_flag,
  usage_flag,
  groupings_record,
  info,
  config,
  simulation_constants,
  constraints
)
}
\arguments{
\item{j}{the examinee index.}

\item{position}{the item position, ranging from 1 to test length.}

\item{o}{\code{\linkS4class{output_Shadow}} object.}

\item{eligibility_flag}{a named list containing eligibility flags.}

\item{exclude_flag}{a list of item/stimulus indices to exclude from selection for the examinee.}

\item{usage_flag}{a vector of length \emph{ni} (or \emph{ni + ns}) containing the number of times each item has been administered previously to the examinee.}

\item{groupings_record}{a list containing data on completed item sets.}

\item{info}{a vector containing item information of each item in the pool.}

\item{config}{a \code{\linkS4class{config_Shadow}} object. Use \code{\link{createShadowTestConfig}} for this.}

\item{simulation_constants}{a named list containing simulation constants.}

\item{constraints}{a \code{\linkS4class{constraints}} object representing test specifications. Use \code{\link{loadConstraints}} for this.}
}
\value{
a named list containing a shadowtest and related data.
\itemize{
  \item{\code{shadow_test}} a \code{\link{data.frame}} containing the shadowtest.
  \item{\code{feasible} whether the assembly was feasible the first time.}
}
}
\description{
(Internal) Assemble a shadowtest
}
\keyword{internal}
