% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayes_functions.R
\name{getBayesianConstants}
\alias{getBayesianConstants}
\title{(Internal) Parse Bayesian-related constants}
\usage{
getBayesianConstants(config, simulation_constants)
}
\arguments{
\item{config}{a \code{\linkS4class{config_Shadow}} object. Use \code{\link{createShadowTestConfig}} for this.}

\item{simulation_constants}{a named list containing simulation constants.}
}
\value{
\code{\link{getBayesianConstants}} returns a named list containing:
\describe{
  \item{\code{final_theta_prior_densities}}{prior densities for final theta estimation for all examinees.}
}
If interim or final theta estimation method is \code{EB} or \code{FB}, the following are included in the list:
\describe{
  \item{\code{n_sample}}{the length of MCMC chain for theta estimation.}
  \item{\code{burn_in}}{the length of MCMC chain to trim from the start of the chain.}
  \item{\code{thin}}{the thinning interval to apply to the chain.}
  \item{\code{jump_factor}}{the scaling factor.}
}
}
\description{
\code{\link{getBayesianConstants}} is an internal function for parsing Bayesian-related constants
}
\keyword{internal}
