% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RFF.R
\name{RFF_get}
\alias{RFF_get}
\title{Create a new RFF function}
\usage{
RFF_get(D = 2, M = 30, wave = sin, noise = 0, seed = NULL)
}
\arguments{
\item{D}{Number of dimensions}

\item{M}{Number of random waves}

\item{wave}{Type of wave}

\item{noise}{Standard deviation of random normal noise to add}

\item{seed}{Seed to set before randomly selecting function}
}
\value{
A random wave function
}
\description{
Create a new RFF function
}
\examples{
func <- RFF_get(D=1)
curve(func)

f <- RFF_get(D=1, noise=.1)
curve(f(matrix(x,ncol=1)))
for(i in 1:100) curve(f(matrix(x,ncol=1)), add=TRUE, col=sample(2:8,1))
}
