% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date_time.R
\name{date_time_}
\alias{date_time_}
\title{Concatenate Date and Time}
\usage{
date_time_(date_, time_)
}
\arguments{
\item{date_}{an R object containing \link[base]{Date} information}

\item{time_}{an R object containing time (\link[base]{POSIXt}) information}
}
\value{
Function \link{date_time_} returns a \link[base]{POSIXct} object.
}
\description{
Concatenate date and time information from two objects.
}
\details{
Function \link{date_time_} is useful as clinicians may put date and time in different columns.
}
\examples{
(today = Sys.Date())
(y = ISOdatetime(year = c(1899, 2010), month = c(12, 3), day = c(31, 22), 
  hour = c(15, 3), min = 2, sec = 1, tz = 'UTC'))
date_time_(today, y)
}
