% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Tm_Wallace.R
\encoding{UTF-8}
\name{Tm_Wallace}
\alias{Tm_Wallace}
\title{Calculate the melting temperature using the 'Wallace rule'}
\usage{
Tm_Wallace(ntseq, ambiguous = FALSE, outlist = TRUE)
}
\arguments{
\item{ntseq}{Sequence (5' to 3') of one strand of the DNA nucleic acid duplex
as string or vector of characters (\strong{Note:} Non-DNA characters are ignored
by this method).}

\item{ambiguous}{Ambiguous bases are taken into account to compute the G and C content when ambiguous is TRUE.}

\item{outlist}{output a list of Tm and options or only Tm value, default is TRUE.}
}
\description{
The Wallace rule is often used as rule of thumb for approximate melting temperature calculations for primers with 14 to 20 nt length.
}
\examples{

ntseq = c('acgtTGCAATGCCGTAWSDBSY') #for wallace rule

out <- Tm_Wallace(ntseq,ambiguous = TRUE)
out
out$Options

}
\references{
Thein S L , Lynch J R , Weatherall D J , et al. DIRECT DETECTION OF HAEMOGLOBIN E WITH SYNTHETIC OLIGONUCLEOTIDES[J]. The Lancet, 1986, 327(8472):93.
}
\author{
Junhui Li
}
