% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Consistency.R
\name{Consistency}
\alias{Consistency}
\title{Consistency / retention "indices"}
\usage{
Consistency(dataset, tree, nRelabel = 0, compress = FALSE)
}
\arguments{
\item{dataset}{A phylogenetic data matrix of \pkg{phangorn} class
\code{phyDat}, whose names correspond to the labels of any accompanying tree.
Perhaps load into R using \code{\link[TreeTools]{ReadAsPhyDat}}.
Additive (ordered) characters can be handled using
\code{\link[TreeTools]{Decompose}}.}

\item{tree}{A tree of class \code{\link[ape:read.tree]{phylo}}.}

\item{nRelabel}{Integer specifying how many times to relabel leaves when
estimating null tree length for \acronym{RHI} calculation.
\insertCite{Steell2023;textual}{TreeSearch} recommend 1000, but suggest that
100 may suffice.
If zero (the default), the \acronym{RHI} is not calculated.}

\item{compress}{Logical specifying whether to retain the compression of a
\code{phyDat} object or to return a vector specifying to each individual
character, decompressed using the dataset's \code{index} attribute.}
}
\value{
\code{Consistency()} returns a matrix with named columns specifying the
consistency index (\code{ci}),
retention index (\code{ri}),
rescaled consistency index (\code{rc}) and
relative homoplasy index (\code{rhi}).
}
\description{
\code{Consistency()} calculates the consistency "index" and retention index
\insertCite{Farris1989}{TreeSearch}
for each character in a dataset, given a bifurcating tree.
Although there is not a straightforward interpretation of these indices,
they are sometimes taken as an indicator of the fit of a character to a
tree.
Values correlate with the number of species sampled and the
distribution of taxa between character states, so are not strictly comparable
between characters in which these factors differ; and values cannot be
compared between datasets \insertCite{Speed2017}{TreeSearch}.
}
\details{
The \strong{consistency "index"} \insertCite{Kluge1969}{TreeSearch} is defined as the
number of steps observed in the most parsimonious mapping of a character
to a tree, divided by the number of steps observed on the shortest possible
tree for that character. A value of one indicates that a character's fit to
the tree is optimal.
Note that as the possible values of the consistency index do not range from
zero to one, it is not an index in the mathematical sense of the term.
Shortcomings of this measure are widely documented
\insertCite{Archie1989,Brooks1986,Steell2023}{TreeSearch}.

The maximum length of a character (see \code{\link[=MaximumLength]{MaximumLength()}}) is the
number of steps in a parsimonious reconstruction on the longest possible tree
for a character.
The \strong{retention index} is the maximum length of a character minus the number
of steps observed on a given tree; divided by the maximum length minus the
minimum length.  It is interpreted as the ratio between the observed
homoplasy, and the maximum observed homoplasy, and scales from zero
(worst fit that can be reconstructed under parsimony) to one (perfect fit).

The \strong{rescaled consistency index} is the product of the consistency and
retention indices; it rescales the consistency index such that its range of
possible values runs from zero (least consistent) to one
(perfectly consistent).

The \strong{relative homoplasy index} \insertCite{Steell2023}{TreeSearch} is
the ratio of the observed excess tree length to the excess tree length
due to chance, taken as the median score of a character when the leaves
of the given tree are randomly shuffled.

The lengths of characters including inapplicable tokens are calculated
following \insertCite{Brazeau2019;textual}{TreeSearch}, matching their
default treatment in \code{\link[=TreeLength]{TreeLength()}}.
}
\examples{
data(inapplicable.datasets)
dataset <- inapplicable.phyData[[4]]
head(Consistency(dataset, TreeTools::NJTree(dataset), nRelabel = 10))
}
\references{
\insertAllCited{}
}
\author{
\href{https://smithlabdurham.github.io/}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
