% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/laplace_rule.R
\name{laplace}
\alias{laplace}
\title{Laplace's Rule Function}
\usage{
laplace(x = NULL, y = NULL, learn = FALSE, interactive = FALSE)
}
\arguments{
\item{x}{Optional first vector (not needed for interactive mode)}

\item{y}{Optional second vector (not needed for interactive mode)}

\item{learn}{Logical, if TRUE shows step-by-step explanation}

\item{interactive}{Logical, if TRUE enables interactive practice mode}
}
\value{
The probability according to Laplace's Rule (for non-interactive mode)
}
\description{
This function calculates Laplace's Rule for a probability experiment.
}
\examples{
data <- 3
data2 <- c(1,2,3,4,5,6)

# Simple calculation
laplace(data, data2)

# Learning mode
laplace(data, data2, learn = TRUE)

# Interactive mode
if(interactive()){
laplace(interactive = TRUE)
}

}
