% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fast.upsilon.test.R
\name{fast.upsilon.test}
\alias{fast.upsilon.test}
\title{Fast Upsilon Test of Association 
  between Two Categorical Variables}
\usage{
fast.upsilon.test(x, y, log.p = FALSE)
}
\arguments{
\item{x}{a vector to 
specify observations of the first 
categorical variable. The vector can be of
numeric, character, or logical type.
\code{NA} values must be removed or
replaced before calling the function.}

\item{y}{a vector to specify observations of 
the second categorical variable. 
  Must not contain \code{NA} values and 
  must be of the same length as \code{x}.}

\item{log.p}{a logical. If \code{TRUE}, 
the \emph{p}-value is calculated in
closed form to \strong{natural logarithm} of \emph{p}-value 
to improve numerical precision when
\emph{p}-value approaches zero.
Defaults to \code{FALSE}.}
}
\value{
A list with class \code{"htest"} containing the following components:
\item{statistic}{the Upsilon test statistic.}
\item{parameter}{the degrees of freedom.}
\item{p.value}{the \emph{p}-value of the test.}
\item{estimate}{the effect size derived from the Upsilon statistic.}
\item{method}{a character string indicating the method used.}
\item{data.name}{a character string giving the name of input data.}
}
\description{
Performs a fast Upsilon test 
\insertCite{luo2021upsilon}{Upsilon} 
to evaluate association between 
observations from two categorical variables.
}
\details{
The Upsilon test is designed to promote 
 dominant function patterns. In contrast to other
 tests of association to favor all function
 patterns, it is unique in demoting non-dominant
 function patterns.
 
 Null hypothesis (\eqn{H_0}): Row and column variables are 
   statistically independent.
 
 Null population: A discrete uniform distribution,
   where each entry in the table has the same
   probability.

 Null distribution: The Upsilon test statistic 
   asymptotically follows a chi-squared distribution
   with \code{(nrow(x) - 1)(ncol(x) - 1)} degrees of freedom,
   under the null hypothesis on the null population.
   
 See \insertCite{luo2021upsilon}{Upsilon} for full 
 details of the Upsilon test.
}
\note{
The test uses an internal 
  hash table, instead of matrix, to
  store the contingency table. Savings in 
  both runtime and memory saving can be
  substantial if the contingency table is 
  sparse and large. The test is implemented
  in C++, to give an additional layer of
  speedup over an R implementation.
}
\examples{
library("Upsilon")

weather <- c(
  "rainy", "sunny", "rainy", "sunny", "rainy"
)
mood <- c(
  "wistful", "upbeat", "upbeat", "upbeat", "wistful"
)

fast.upsilon.test(weather, mood)

# The result is equivalent to: 
upsilon.test(table(weather, mood))
}
\references{
\insertRef{luo2021upsilon}{Upsilon}
}
