% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ffvd.R
\name{ffvd}
\alias{ffvd}
\title{Defining variable domain functional data terms in vd_fit formulae}
\usage{
ffvd(X, grid, nbasis = c(30, 50, 30), bdeg = c(3, 3, 3))
}
\arguments{
\item{X}{variable domain functional covariate \code{matrix}.}

\item{grid}{observation points of the variable domain functional covariate.
If not provided, it will be \code{1:ncol(X)}.}

\item{nbasis}{number of bspline basis to be used.}

\item{bdeg}{degree of the bspline basis used.}
}
\value{
the function is interpreted in the formula of a \code{VDPO} model.
\code{list} containing the following elements:
\itemize{
\item An item named \code{B} design matrix.
\item An item named \code{X_hat} smoothed functional covariate.
\item An item named \code{L_Phi} and \code{B_T} 1-dimensional marginal B-spline basis used for the functional coefficient.
\item An item named \code{M} matrix object indicating the observed domain of the data.
\item An item named \code{nbasis} number of basis used.
}
}
\description{
Auxiliary function used to define \code{ffvd} terms within \code{vd_fit} model formulae.
This term represents a functional predictor where each function is observed over a domain of varying length.
The formulation is \eqn{\frac{1}{T_i} \int _1^{T_i} X_i(t)\beta(t,T_i)dt}, where \eqn{X_i(t)} is a functional covariate of length \eqn{T_i}, and \eqn{\beta(t,T_i)} is an unknown bivariate functional coefficient.
The functional basis used to model this term is the B-spline basis.
}
\examples{
# Generate sample data
set.seed(123)
data <- data_generator_vd(beta_index = 1, use_x = FALSE, use_f = FALSE)
X <- data$X_se

# Specifying a custom grid
custom_grid <- seq(0, 1, length.out = ncol(X))
ffvd_term_custom_grid <- ffvd(X, grid = custom_grid, nbasis = c(10, 10, 10))

# Customizing the number of basis functions
ffvd_term_custom_basis <- ffvd(X, nbasis = c(10, 10, 10))

# Customizing both basis functions and degrees
ffvd_term_custom <- ffvd(X, nbasis = c(10, 10, 10), bdeg = c(3, 3, 3))

}
