% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VDSM_Hplot.R
\name{Hplot}
\alias{Hplot}
\title{Hplot.}
\usage{
Hplot(
  X,
  f,
  p,
  Anchor.model = NULL,
  xlim = NULL,
  ylim = NULL,
  circlesize = NULL,
  linewidth = NULL,
  fontsize = NULL
)
}
\arguments{
\item{X}{A m*p matrix which contains m different p-dimensional models. All the elements are either 0 or 1.}

\item{f}{A vector with m elements which represent each model's frequency in X.}

\item{p}{The number of variate in the model.}

\item{Anchor.model}{A vector containing p elements with either 1 or 0 value and must be found in X. Default is the model with the highest frequency.}

\item{xlim}{A vector with two elements which determine the range of x-axis in the plot.}

\item{ylim}{A vector with two elements which determine the range of y-axis in the plot.}

\item{circlesize}{customize the size of the circle in the plot, default is 10.}

\item{linewidth}{Customize the width of the line in the plot, default is 1.}

\item{fontsize}{Customize the size of the font in the circles, default is 1.5.}
}
\value{
A list with components
\item{Hplot.info}{The table includes all the information about each group, i.e., the total possible number of models in the group and the actual existing number of model in the group.}
\item{Hplus.histogram}{The frequency of Hamming distance plus.}
\item{Hminus.histogram}{The frequency of Hamming distance minus.}
}
\description{
Plotting Hplot.
}
\examples{
data(exampleX)
X=exampleX
data(examplef)
f=examplef
p=8
H_example1 = Hplot(X,f,p)
H_example2 = Hplot(X,f,p,xlim=c(0,4),ylim=c(0,2))
H_example3 = Hplot(X,f,p,xlim=c(0,4),ylim=c(0,2),circlesize=15,linewidth=2,fontsize=3)
}
