% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textAnalysis.R
\name{wordCloudPlot}
\alias{wordCloudPlot}
\title{Create a wordcloud plot}
\usage{
wordCloudPlot(
  word_freqs,
  seed = NULL,
  min_freq = 1,
  max_words = 50,
  pcolors = NULL,
  family = NULL,
  ...
)
}
\arguments{
\item{word_freqs}{Table. Table of word frequencies.}

\item{seed}{Numeric. Seed value can be supplied to reproduce a word cloud layout.}

\item{min_freq}{Numeric. Minimum word frequency to include a word in the word cloud. Default is \code{1}.}

\item{max_words}{Numeric. Maximum number of words to render in the word cloud. Default is \code{50}.}

\item{pcolors}{List. Colors to assign categorical variable in the plot or palette to use if \code{random.color}.
Default is \code{NULL}.}

\item{family}{Character. Set a font family for plot labels. Default is \code{NULL}.}

\item{...}{
  Arguments passed on to \code{\link[wordcloud:wordcloud]{wordcloud::wordcloud}}
  \describe{
    \item{\code{random.order}}{plot words in random order. If false, they will be plotted in decreasing frequency}
    \item{\code{random.color}}{choose colors randomly from the colors. If false, the color is chosen based on the frequency}
    \item{\code{rot.per}}{proportion words with 90 degree rotation}
  }}
}
\value{
A wordcloud plot.
}
\description{
This function creates a wordcloud plot from word frequencies.
}
