% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.VPdtw.R
\name{plot.VPdtw}
\alias{plot.VPdtw}
\title{Plot VPdtw object}
\usage{
\method{plot}{VPdtw}(
  x,
  type = c("All", "Before", "After", "Shift", "Chromatograms"),
  xlim = NULL,
  ...
)
}
\arguments{
\item{x}{A VPdtw object generated by \code{VPdtw}.}

\item{type}{What to plot.}

\item{xlim}{Numeric vector specifying x-axis limits.}

\item{...}{Additional arguments}
}
\value{
No return value, called for side effects.
}
\description{
Plot VPdtw object
}
\section{Side effects}{

Plots information about alignment according to value of \code{type}: either
unaligned query and reference (\code{"Before"}), aligned query and reference
(\code{"After"}), shift at each index (\code{"Shift"}), a three-panel plot
containing all three of these options (\code{"All"}), or a two-panel plot with
unaligned and aligned query (\code{"Chromatograms"}).
}

\examples{

  query <- c(1,5,4,3,9,8,5,2,6,5,4)
  reference <- c(rnorm(5), query, rnorm(5))
  lambda <- rep(0, length(reference))
  maxshift <- 11
  res <- VPdtw(reference, query, lambda, maxshift)
  plot(res)
  
}
