% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotate-data.R
\name{annotate_data}
\alias{annotate_data}
\title{Finds midpoints and bands for the within and between cycles.}
\usage{
annotate_data(
  ds_linear,
  dv_name,
  center_function,
  spread_function,
  cycle_tally_name = "cycle_tally",
  stage_id_name = "stage_id",
  stage_progress_name = "stage_progress",
  proportion_through_cycle_name = "proportion_through_cycle",
  proportion_id_name = "proportion_id",
  terminal_point_in_cycle_name = "terminal_point_in_cycle"
)
}
\arguments{
\item{ds_linear}{The \link{data.frame} to containing the detailed data.}

\item{dv_name}{The name of the dependent/criterion variable.}

\item{center_function}{A function to calculate the center of a subsample.}

\item{spread_function}{A function to calculate the bands of a subsample.}

\item{cycle_tally_name}{The variable name indicating how many cycles have been completed.}

\item{stage_id_name}{The variable name indicating the stage.
In a typical interrupted time series, these values are
"1" before the interruption and "2" after.}

\item{stage_progress_name}{The variable name indicating the stage in a decimal form.
This is mostly for internal uses.}

\item{proportion_through_cycle_name}{The variable name indicating how far the point
is through a cycle.  For example, 0 degrees would be \code{0},
180 degrees would be \code{0.5}, 359 degrees would be \code{0.9972}, and
360 degrees would be \code{0}.}

\item{proportion_id_name}{The variable name indicating the ordinal position through a cycle.}

\item{terminal_point_in_cycle_name}{The variable name indicating the last point
within a given cycle.}
}
\value{
Returns a \code{\link[tibble:tibble]{tibble::tibble()}} with additional variables.
TODO: say what the variables are.
}
\description{
Finds midpoints and bands for the within and between cycles.
This the second of two functions
that needs to be called to produce WATS Plots.  \code{AugmentZZZ} is the first.
}
\examples{
system.time({
library(Wats)
ds_linear <-
  Wats::county_month_birth_rate_2005_version |>
  dplyr::filter(county_name == "oklahoma") |>
  augment_year_data_with_month_resolution(date_name = "date")

h_spread <- \(scores) { quantile(x = scores, probs = c(.25, .75)) }

portfolio <- annotate_data(
  ds_linear       = ds_linear,
  dv_name         = "birth_rate",
  center_function = median,
  spread_function = h_spread
)
portfolio$ds_stage_cycle
portfolio$ds_linear
portfolio$ds_periodic
})
}
