% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_color_WB_d.R
\name{scale_color_WB_d}
\alias{scale_color_WB_d}
\title{Use WrensBookshelf with ggplot}
\usage{
scale_color_WB_d(name, direction = 1, override.order = FALSE, ...)
}
\arguments{
\item{name}{Name of palette from WrensBookshelf.}

\item{direction}{Direction you want the palette to proceed;
1 = direction shown in ShowBookshelf() or ShowBook(), -1 = reversed.}

\item{override.order}{Argument used to override the prescribed order that colors
are selected from palettes for discrete palettes where n < length(palette). Default = FALSE.}

\item{...}{See discrete_scale() for additional params.}
}
\value{
No return value, integrates WB_brewer into ggplot2 function.
}
\description{
Wrapper function to allow easy integration with ggplot2. Sets discrete color scale
}
\examples{
ggplot2::ggplot(mtcars, ggplot2::aes(x = disp,y = wt, color = factor(cyl)))+
ggplot2::geom_point(size=3)+
scale_color_WB_d(name = "YouMatter")
}
