% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delay_discounting_fit.R
\name{exp_fit}
\alias{exp_fit}
\title{Exponential fit with nls}
\usage{
exp_fit(value, delay, initial_guess, max_iter = 1e+05, scale_offset = 0)
}
\arguments{
\item{value}{A numeric vector of the subjective values (indifference points).}

\item{delay}{A numeric vector of the delays used in the experiment.}

\item{initial_guess}{A numeric value providing an initial estimate for the parameter \code{k}.}

\item{max_iter}{An integer specifying the maximum number of iterations for the nls fitting algorithm.
Default is 1e5.}

\item{scale_offset}{A numeric value for the scaling offset used in nls fitting control. Default is 0.}
}
\value{
An object of class \code{nls} containing the fitted model.
}
\description{
This function performs an exponential fit using non-linear least squares (nls).
}
\examples{
# See the examples of hyp_fit
}
