% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ypbp.R
\name{ypbp}
\alias{ypbp}
\alias{{ypbp}}
\title{Fits the Yang and Prentice using Bernstein polynomials to model the baseline distribution.}
\usage{
ypbp(
  formula,
  data,
  degree = NULL,
  tau = NULL,
  approach = c("mle", "bayes"),
  baseline = c("hazard", "odds"),
  hessian = TRUE,
  hyper_parms = list(h1_gamma = 0, h2_gamma = 4, mu_psi = 0, sigma_psi = 4, mu_phi = 0,
    sigma_phi = 4, mu_beta = 0, sigma_beta = 4),
  ...
)
}
\arguments{
\item{formula}{an object of class "formula" (or one that can be coerced to that class): a symbolic description of the model to be fitted.}

\item{data}{an optional data frame, list or environment (or object coercible by as.data.frame to a data frame) containing the variables in the model. If not found in data, the variables are taken from environment(formula), typically the environment from which ypbp is called.}

\item{degree}{number of intervals of the PE distribution. If NULL, default value (square root of n) is used.}

\item{tau}{the maximum time of follow-up. If NULL, tau = max(time), where time is the vector of observed survival times.}

\item{approach}{approach to be used to fit the model (mle: maximum likelihood; bayes: Bayesian approach).}

\item{baseline}{baseline function to be modeled.}

\item{hessian}{logical; If TRUE (default), the hessian matrix is returned when approach="mle".}

\item{hyper_parms}{a list containing the hyper-parameters of the prior distributions (when approach = "bayes"). If not specified, default values are used.}

\item{...}{Arguments passed to either `rstan::optimizing` or `rstan::sampling` .}
}
\value{
ypbp returns an object of class "ypbp" containing the fitted model.
}
\description{
Fits the Yang and Prentice model with either the baseline hazard hazard or the baseline odds modeled via Bernstein polynomials.
}
\examples{
\donttest{
library(YPBP)
mle1 <- ypbp(Surv(time, status)~trt, data=gastric, baseline = "hazard")
mle2 <- ypbp(Surv(time, status)~trt, data=gastric, baseline = "odds")
bayes1 <- ypbp(Surv(time, status)~trt, data=gastric, baseline = "hazard",
               approach = "bayes", chains = 2, iter = 500)
bayes2 <- ypbp(Surv(time, status)~trt, data=gastric, baseline = "odds",
               approach = "bayes", chains = 2, iter = 500)
}


}
