% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival_yppe.R
\name{crossTime.yppe}
\alias{crossTime.yppe}
\title{Computes the crossing survival times}
\usage{
\method{crossTime}{yppe}(object, newdata1, newdata2, conf.level = 0.95, nboot = 4000, ...)
}
\arguments{
\item{object}{an object of class yppe}

\item{newdata1}{a data frame containing the first set of explanatory variables}

\item{newdata2}{a data frame containing the second set of explanatory variables}

\item{conf.level}{level of the confidence/credible intervals}

\item{nboot}{number of bootstrap samples (default nboot=4000); ignored if approach="bayes".}

\item{...}{further arguments passed to or from other methods.}
}
\value{
the crossing survival time
}
\description{
Computes the crossing survival times
}
\examples{
\donttest{
# ML approach:
library(YPPE)
mle <- yppe(Surv(time, status)~arm, data=ipass, approach="mle")
summary(mle)
newdata1 <- data.frame(arm=0)
newdata2 <- data.frame(arm=1)
tcross <- crossTime(mle, newdata1, newdata2)
tcross
ekm <- survfit(Surv(time, status)~arm, data=ipass)
newdata <- data.frame(arm=0:1)
St <- survfit(mle, newdata)
time <- sort(ipass$time)
plot(ekm, col=1:2)
lines(time, St[[1]])
lines(time, St[[2]], col=2)
abline(v=tcross, col="blue")

# Bayesian approach:
bayes <- yppe(Surv(time, status)~arm, data=ipass, approach="bayes")
summary(bayes)
newdata1 <- data.frame(arm=0)
newdata2 <- data.frame(arm=1)
tcross <- crossTime(bayes, newdata1, newdata2)
tcross
ekm <- survfit(Surv(time, status)~arm, data=ipass)
newdata <- data.frame(arm=0:1)
St <- survfit(bayes, newdata)
time <- sort(ipass$time)
plot(ekm, col=1:2)
lines(time, St[[1]])
lines(time, St[[2]], col=2)
abline(v=tcross, col="blue")
}

}
