% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/daily_precip_totals.R
\name{daily.precip.totals}
\alias{daily.precip.totals}
\title{Return daily precipitation totals for a site}
\usage{
daily.precip.totals(site, bgn.date, end.date)
}
\arguments{
\item{site}{Parameter of class character.
The NEON site data should be downloaded for.}

\item{bgn.date}{Optional. The start date of the period to generate statistics for.
If not supplied, the first date of NEON data will be used.}

\item{end.date}{Optional. The end date of the period to generate statistics for.
If not supplied, the last date of NEON data will be used.}
}
\value{
A data frame of primary and secondary precipitation totals by date. 
Totals are in millimeters.
}
\description{
This function calculates the daily precipitation totals over the
 specified date range
}
\examples{
\dontrun{
# Return the entire period of record at CPER
cper=Z10::daily.precip.totals(site = "CPER")
}
}
\seealso{
Currently none
}
\author{
Robert Lee \email{rhlee@colorado.edu}\cr
}
