% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree.R
\docType{class}
\name{VT.tree}
\alias{VT.tree}
\title{Tree to find subgroup}
\description{
An abstract reference class to compute tree
}
\details{
\code{VT.tree.class} and \code{VT.tree.reg} are children of \code{VT.tree}.
\code{VT.tree.class} and \code{VT.tree.reg} try to find a strong association 
between \code{difft} (in \code{VT.difft} object) and RCT variables.

In \code{VT.tree.reg}, a regression tree is computed on \code{difft} values. 
Then, thanks to the \code{threshold} it flags leafs of the \code{tree} which 
are above the \code{threshold} (when \code{sens} is ">"). Or it flags leafs 
which are below the \code{threshold} (when \code{sens} = "<").

In \code{VT.tree.class}, it first flags \code{difft} above or below 
(depending on the \code{sens}) the given \code{threshold}. Then a 
classification tree is computed to find which variables explain flagged 
\code{difft}.

To sum up, \code{VT.tree} try to understand which variables are associated 
with a big change of \code{difft}.

Results are shown with \code{getRules()} function. \code{only.leaf} parameter
allows to obtain only the leaf of the \code{tree}. \code{only.fav} parameter 
select only favorable nodes. \code{tables} shows incidence table of the rule.
\code{verbose} allow \code{getRules()} to be quiet. And \code{compete} show
also rules with \code{maxcompete} competitors from the \code{tree}.
}
\section{Fields}{

\describe{
\item{\code{vt.difft}}{\code{VT.difft} object}

\item{\code{outcome}}{outcome vector from \code{rpart} function}

\item{\code{threshold}}{numeric Threshold for difft calculation (c)}

\item{\code{screening}}{Logical. TRUE if using varimp. Default is VT.object 
screening field}

\item{\code{sens}}{character Sens can be ">" (default) or "<". Meaning : 
\code{difft} > \code{threshold} or \code{difft} < \code{threshold}}

\item{\code{name}}{character Names of the tree}

\item{\code{tree}}{rpart Rpart object to construct the tree}

\item{\code{Ahat}}{vector Indicator of beglonging to Ahat}
}}

\section{Methods}{

\describe{
\item{\code{computeNameOfTree(type)}}{return label of response variable of the tree}

\item{\code{createCompetitors()}}{Create competitors table}

\item{\code{getAhatIncidence()}}{Return Ahat incidence}

\item{\code{getAhatQuality()}}{Return Ahat quality}

\item{\code{getData()}}{Return data used for tree computation}

\item{\code{getIncidences(rule, rr.snd = T)}}{Return incidence of the rule}

\item{\code{getInfos()}}{Return infos about tree}

\item{\code{getRules(only.leaf = F, only.fav = F, tables = T, verbose = T,
  compete = F)}}{Return subgroups discovered by the tree. See details.}

\item{\code{run(...)}}{Compute tree with rpart parameters}
}}

\seealso{
\code{\link{VT.tree.reg}}, \code{\link{VT.tree.class}}
}
