% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unifrac.R
\name{match_to_tree}
\alias{match_to_tree}
\title{Match vector of counts to phylogenetic tree}
\usage{
match_to_tree(x, tree, x_labels = NULL)
}
\arguments{
\item{x}{A vector of species counts.}

\item{tree}{A phylogenetic tree of class \code{"phylo"}.}

\item{x_labels}{A vector of species labels for \code{x}.}
}
\value{
The vector \code{x}, re-arranged to match the tree.
}
\description{
Match vector of counts to phylogenetic tree
}
\details{
This function applies a couple of different methods to arrange the
  data in \code{x} to match a phylogenetic tree.
  \itemize{
    \item If \code{x_labels} is provided, we use this vector to match the
      elements of \code{x} with the tip labels in the tree.
    \item If \code{x_labels} is not provided and \code{x} is a named vector,
      we use the names to match the tip labels in the tree.
    \item If \code{x_labels} is not provided and \code{x} is not named, we
      assume that \code{x} is already in the correct order, check that the
      length of \code{x} matches the number of tips in the tree, and return
      \code{x}.
  }
}
