% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alpha.R
\name{strong}
\alias{strong}
\title{Strong's dominance index}
\usage{
strong(x)
}
\arguments{
\item{x}{A numeric vector of species counts.}
}
\value{
Strong's dominance index, \eqn{0 \leq D_W < 1}. The index is
  undefined if \code{x} sums to 0, and we return \code{NaN} in this case.
}
\description{
Strong's dominance index measures the maximum departure between the observed
proportions and a perfectly even community.
}
\details{
Strong's dominance index is defined as
\deqn{D_W = \max_i \left [ \frac{b_i}{N} - \frac{i}{S} \right ],} where
\eqn{b_i} is the abundance of the \eqn{i}th species, ordered from smallest
to largest, \eqn{N} is the total number of counts, and \eqn{S} is the number
of species observed.

Equivalent to \code{strong()} in \code{skbio.diversity.alpha}.
}
\examples{
x <- c(9, 0, 1, 2, 5, 2, 1, 1, 0, 7, 2, 1, 0, 1, 1)
strong(x)
}
\references{
Strong WL. Assessing species abundance uneveness within and between plant
communities. Community Ecology. 2002;3:237-246.
}
