% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotLive}
\alias{plotLive}
\title{Plot array live times}
\usage{
plotLive(
  input,
  arrays,
  show.stations = FALSE,
  array.size = 2,
  station.size = 1,
  show.caps = TRUE,
  cap.prop = 2,
  title = "",
  xlab = "",
  ylab = "",
  col
)
}
\arguments{
\item{input}{An actel results object, or a preload object}

\item{arrays}{Optional: A subset of arrays to be plotted}

\item{show.stations}{Logical: Should the live times of each station be shown under the array bars?}

\item{array.size}{The size of the array bars (defaults to 2)}

\item{station.size}{The size of the station bars (defaults to 1)}

\item{show.caps}{Logical: Should cap lines be shown at the end of each live period?}

\item{cap.prop}{The relative size of the caps, as compared to the respective bars (defaults to 2).}

\item{title}{An optional title for the plot.}

\item{xlab, ylab}{Optional axis names for the plot.}

\item{col}{An optional colour scheme for the array bars. If left empty, default colours will be added.
Note: Station bars are 40\% lighter than the array bars.}
}
\value{
A ggplot object.
}
\description{
Plot array live times
}
\examples{
# Using the example results that come with actel
plotLive(example.results)

# Because plotLive returns a ggplot object, you can store
# it and edit it manually, e.g.:
library(ggplot2)
p <- plotLive(example.results)
p <- p + xlab("changed the x axis label a posteriori")
p

# You can also save the plot using ggsave!

}
