% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adephylo-package.R
\docType{data}
\name{palm}
\alias{palm}
\title{Phylogenetic and quantitative traits of amazonian palm trees}
\format{
\code{palm} is a list containing the 2 following objects: \describe{
\item{tre}{is a character string giving the phylogenetic tree in Newick
format.} \item{traits}{is a data frame with 66 species (rows) and 7 traits
(columns).} }
}
\source{
This data set was obtained by Clementine Gimaret-Carpentier.
}
\description{
This data set describes the phylogeny of 66 amazonian palm trees. It also
gives 7 traits corresponding to these 66 species.
}
\details{
Variables of \code{palm$traits} are the following ones: \cr - rord: specific
richness with five ordered levels\cr - h: height in meter (squared
transform)\cr - dqual: diameter at breast height in centimeter with five
levels \code{sout : subterranean}, \code{ d1(0, 5 cm)}, \code{ d2(5, 15
cm)}, \code{ d3(15, 30 cm)} and \code{ d4(30, 100 cm)}\cr - vfruit: fruit
volume in \eqn{mm^{3}}{mm^3} (logged transform)\cr - vgrain: seed volume in
\eqn{mm^{3}}{mm^3} (logged transform)\cr - aire: spatial distribution area
(\eqn{km^{2}}{km^2})\cr - alti: maximum altitude in meter (logged
transform)\cr
}
\note{
This dataset replaces the former version in ade4.
}
\examples{


if(require(ape) && require(phylobase)){

## load data, make a tree and a phylo4d object
data(palm)
tre <- read.tree(text=palm$tre)
rord <- as.integer(palm$traits$rord) # just use this for plotting purpose
traits <- data.frame(rord, palm$traits[,-1])
x <- phylo4d(tre, traits)

## plot data
oldpar <- par(mar=rep(.1,4))
table.phylo4d(x, cex.lab=.6)

## test phylogenetic autocorrelation
if(require(ade4)){
prox <- proxTips(x, method="sumDD")
phylAutoTests <- gearymoran(prox, traits[,-3], nrep=499)
plot(phylAutoTests)
}
par(oldpar)
}


}
\keyword{datasets}
