% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Calculations.R
\name{calculate_pdc}
\alias{calculate_pdc}
\title{Calculate Proportion Days Covered}
\usage{
calculate_pdc(.data, .summarise = TRUE)
}
\arguments{
\item{.data}{data frame}

\item{.summarise}{Logical value (defaulting to TRUE) indicating whether the output should be summarised or not}
}
\value{
a summarised tibble, by default, with proportion of days covered calculated
}
\description{
Calculate the proportion of days covered (PDC) from a pharmaceutical claims database. This function is suggested only  
after one has properly adjusted their dates (\code{propagate_date()}) and identified gaps in therapy
(\code{identify_gaps()}). This function calculates a length of total therapy as the first fill date to the last for a given grouping. 
Finally, if you'd like to view adherence by episodes after you have used \code{rank_episodes()}, the function will re-adjust gaps for you so that the gap that defined the episode isn't included.
}
\examples{
library(adheRenceRX)
library(dplyr)

toy_claims \%>\% 
  group_by(ID) \%>\% 
  propagate_date(.date = date, .days_supply = days_supply) \%>\% 
  identify_gaps() \%>\% 
  calculate_pdc()
  
#OR, one could group by the ID and episode of care like...
toy_claims \%>\% 
  group_by(ID) \%>\% 
  propagate_date(.date = date, .days_supply = days_supply) \%>\% 
  identify_gaps() \%>\% 
  rank_episodes(.permissible_gap = 30) \%>\% 
  ungroup() \%>\% 
  group_by(ID, episode) \%>\% 
  calculate_pdc()
}
