% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dev.R
\name{dev}
\alias{dev}
\title{Deviation function}
\usage{
dev(x, min, max)
}
\arguments{
\item{x}{A numeric vector.}

\item{min}{A numeric vector.}

\item{max}{A numeric vector.}
}
\value{
A numeric vector of deviations.
}
\description{
This function calculates the deviation in the sense of the Grantham deviation
as introduced by Tavtigian et al. (2006). Essentially, if \code{x} lies within the
range [\code{min}, \code{max}], then \code{dev()} returns 0. If \code{x} is either below \code{min}, or
above \code{max}, then \code{dev()} returns the absolute difference between \code{x} and
\code{min} or \code{max}, respectively.

\if{html}{\figure{dev-def.svg}{dev definition}}
\if{latex}{\figure{dev-def.png}{options: width=0.5in}}

Inputs are recycled in the sense of \code{\link[vctrs:vec_recycle]{vctrs::vec_recycle()}}.
}
\details{
Here's a plot showcasing \code{dev()} with \code{min = -4} and \code{max = 3}:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{x <- -10:10; min <- -4; max <- 3
plot(x, y = dev(x, min, max), type = 'l', xlab = 'x', ylab = 'deviation')
}\if{html}{\out{</div>}}

\figure{dev-plot-1.png}
}
\examples{
# `dev()` returns absolute differences from either min or max (whichever is
# closest).
dev(10, min = -4, max = 4)
dev(-10, min = -4, max = 4)

# `x` can be a vector
dev(-10:10, min = -4, max = 4)

# `min` and `max` can also be vectors, they will be recycled
dev(-10:10, min = -4:16, max = 4:24)

# If `x` contains `NA` values, then `dev()` will return `NA` for
# those cases
dev(c(10, NA), min = -4, max = 4)

# For each calculation of deviation, only either `min` or `max` is used. If
# the unused parameter is `NA` it won't affect the calculation:
dev(c(10, 3), min = c(NA, -4), max = 4)
dev(c(10, -5), min = -4, max = c(4, NA))

}
\seealso{
\code{\link[=gd]{gd()}}
}
