% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatmaps_crm.R
\name{heatmaps_crm}
\alias{heatmaps_crm}
\alias{autoplot.heatmapcrm}
\title{Function to produce heatmaps from a continuous IRTmodel}
\usage{
heatmaps_crm(model, thetarange = c(-6, 6))

\method{autoplot}{heatmapcrm}(
  object,
  xlab = "Theta",
  nrow = 2,
  ratio = 1,
  col_scheme = "plasma",
  ...
)
}
\arguments{
\item{model}{Output from the function \code{cirtmodel}.}

\item{thetarange}{The range for \code{theta}, default from -6 to 6.}

\item{object}{For autoplot: output of heatmaps_crm function.}

\item{xlab}{For autoplot: xlabel.}

\item{nrow}{For autoplot: number of rows of heatmaps to plot.}

\item{ratio}{For autoplot: ratio for coord_fixed in ggplot.}

\item{col_scheme}{For autoplot: the color scheme for heatmaps. Default value is plasma.}

\item{...}{Other arguments currently ignored.}
}
\value{
Dataframe with output probabilities from the IRT model for all algorithms, an object
of class heatmapcrm.
}
\description{
This function makes a dataframe from the continuous IRTmodel the autoplot function
produces the heatmaps.
}
\examples{
data(classification_cts)
model <- cirtmodel(classification_cts)
obj <- heatmaps_crm(model)
head(obj$df)
autoplot(obj)

}
