% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/droplet-actions.R
\name{droplet_snapshot}
\alias{droplet_snapshot}
\alias{droplet_snapshots_list}
\alias{droplet_restore}
\alias{droplet_backups_list}
\title{Take and restore snapshots.}
\usage{
droplet_snapshot(droplet, name = NULL, wait = TRUE, ...)

droplet_snapshots_list(droplet, ...)

droplet_restore(droplet, image, ...)

droplet_backups_list(droplet, ...)
}
\arguments{
\item{droplet}{A droplet number or the result from a call to
\code{droplets()}}

\item{name}{(character) Optional. Name of the new snapshot you want to
create. If not set, the  snapshot name will default to the current date/time}

\item{wait}{If \code{TRUE} (default), wait until the snapshot has been
completed and is ready for use. If set to \code{FALSE} we return a
droplet object right away after droplet snapshot request has been sent.}

\item{...}{Additional options passed down to \code{\link[httr]{POST}}}

\item{image}{(optional) The image ID of the backup image that you would like
to restore.}
}
\description{
\describe{
\item{snapshot}{Take a snapshot of the droplet once it has been powered
off, which can later be restored or used to create a new droplet from
the same image.}
\item{snapshots_list}{List available snapshots}
\item{backups_list}{List available snapshots}
\item{restore}{Restore a droplet with a previous image or snapshot.
This will be a mirror copy of the image or snapshot to your droplet. Be
sure you have backed up any necessary information prior to restore.}
}
}
\examples{
\dontrun{
d <- droplet_create()
d \%>\% droplet_snapshots_list()
d \%>\% droplet_backups_list()

d \%>\%
  droplet_snapshot() \%>\%
  droplet_power_on() \%>\%
  droplet_snapshots_list()

# To delete safely
d \%>\%
  droplet_snapshot() \%>\%
  droplet_delete() \%>\%
  action_wait()
}
}
