% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenerateReport.R
\name{GenerateReport}
\alias{GenerateReport}
\title{Generate the report}
\usage{
GenerateReport(
  dtpath,
  catVars,
  yvar = NULL,
  model = "linReg",
  title = "Report",
  output_format = "html_document",
  output_dir = tempdir(),
  normality_test_method = "ks",
  interactive.plots = FALSE,
  include.vars = NULL
)
}
\arguments{
\item{dtpath}{dataset path as a string}

\item{catVars}{vector of categorical variables names}

\item{yvar}{y variable name if present else \code{NULL}}

\item{model}{type of model - \code{linReg} for linear regression
\code{binClass} for binary classification and \code{multiClass} for
multiclass classification}

\item{title}{Title of the generated report}

\item{output_format}{output report format. \code{'html_documennt'} for
html file or \code{pdf_document} for pdf file output. OR
\code{c("html_document", "pdf_document")} for both.}

\item{output_dir}{Directory where the output files needs to be stored.}

\item{normality_test_method}{method for normality test for a variable.
 Values can be \code{shapiro}
 for Shapiro-Wilk test or
 \code{'anderson'} for 'Anderson-Darling' test of normality or \code{ks} for
'Kolmogorov-Smirnov'}

\item{interactive.plots}{for interactive variable exploration}

\item{include.vars}{include only these variables from the full data}
}
\value{
creates a rmarkdown and html/pdf file. Returns the output directory
on successful run and \code{FALSE} in case of error
}
\description{
\code{GenerateReport} generates the markdown report in one command
}
\details{
This function creates a rmarkdown report which can be converted to
html or pdf format file.
}
\examples{
# Assigning the temporary folder using tempdir(). replace with required directory
GenerateReport(dtpath = mtcars,
               catVars = c("cyl", "vs", "am", "gear"),
               yvar = "vs", model = "binClass",
               output_format = NULL,
               title = "Report",
               output_dir = tempdir(),          # pass the output directory
               interactive.plots = FALSE)       # set TRUE for interactive

}
