% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/angstroms.R
\name{romsmap}
\alias{romsmap}
\alias{romsmap.SpatialPolygonsDataFrame}
\alias{romsmap.SpatialLinesDataFrame}
\alias{romsmap.SpatialPointsDataFrame}
\title{Remap an object to the ROMS grid.}
\usage{
romsmap(x, ...)

\method{romsmap}{SpatialPolygonsDataFrame}(x, coords, crop = FALSE,
  lonlat = TRUE, ...)

\method{romsmap}{SpatialLinesDataFrame}(x, coords, crop = FALSE,
  lonlat = TRUE, ...)

\method{romsmap}{SpatialPointsDataFrame}(x, coords, crop = FALSE,
  lonlat = TRUE, ...)
}
\arguments{
\item{x}{object to transform to the grid space, e.g. a \code{\link[sp]{Spatial}} object}

\item{...}{unused}

\item{coords}{romscoords RasterStack}

\item{crop}{logical, if \code{TRUE} crop x to the extent of the boundary of the values in coords}

\item{lonlat}{logical, if \code{TRUE} check for need to back-transform to longitude/latitude and do it}
}
\value{
input object with coordinates transformed to space of the coords
}
\description{
Find the nearest-neighbour coordinates of \code{x} in the coordinate arrays of \code{coords}.
}
\details{
The input \code{coords} is a assumed to be a 2-layer RasterStack or RasterBrick and
using \code{nabor::knn} the nearest matching position of the coordinates of \code{x} is found in the grid space of \code{coords}. The
motivating use-case is the curvilinear longitude and latitude arrays of ROMS model output.

No account is made for the details of a ROMS cell, though this may be included in future. We tested only with the "lon_u" and "lat_u"
arrays.
}
\note{
Do not use this for extraction purposes without checking the output, this is best used for exploration
and visualization. Re-mapping ROMS data is better done by looking up the \code{coords_points} within spatial objects,
and transferring via the grid index.
}
\examples{
ant_ice_coords <- romsmap(antarctica, ice_coords)
plot(ice_fake, main = "sea ice in pure grid space")
plot(ant_ice_coords, add = TRUE)


}
