% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orsf_control.R
\name{orsf_control_custom}
\alias{orsf_control_custom}
\title{Custom ORSF control}
\usage{
orsf_control_custom(beta_fun, ...)
}
\arguments{
\item{beta_fun}{(\emph{function}) a function to define coefficients used
in linear combinations of predictor variables. \code{beta_fun} must accept
three inputs named \code{x_node}, \code{y_node} and \code{w_node}, and should expect
the following types and dimensions:
\itemize{
\item \code{x_node} (\emph{matrix}; \code{n} rows, \code{p} columns)
\item \code{y_node} (\emph{matrix}; \code{n} rows, \code{2} columns)
\item \code{w_node} (\emph{matrix}; \code{n} rows, \code{1} column)
}

In addition, \code{beta_fun} must return a matrix with p rows and 1 column. If
any of these conditions are not met, \code{orsf_control_custom()} will let
you know.}

\item{...}{Further arguments passed to or from other methods (not currently used).}
}
\value{
an object of class \code{'orsf_control'}, which should be used as
an input for the \code{control} argument of \link{orsf}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}
}
\seealso{
linear combination control functions
\code{\link{orsf_control}()},
\code{\link{orsf_control_cph}()},
\code{\link{orsf_control_fast}()},
\code{\link{orsf_control_net}()}
}
\concept{orsf_control}
