% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/family.elliptical.R
\name{family.elliptical}
\alias{family.elliptical}
\alias{Cauchy}
\alias{Cnormal}
\alias{Gstudent}
\alias{Glogis}
\alias{Normal}
\alias{Powerexp}
\alias{Student}
\alias{LogisI}
\alias{LogisII}
\alias{GNormal}
\title{Family Objects for Elliptical Models}
\usage{
\method{family}{elliptical}(object, ...)

Normal()

Cauchy()

LogisI()

LogisII()

Student(df = stop("no df argument"))

Powerexp(k = stop("no k argument"))

Glogis(parma = stop("no alpha=alpha(m) or m argument"))

Gstudent(parm = stop("no s or r argument"))

Cnormal(parmt = stop("no epsi or sigma argument"))

GNormal(nu = stop("no nu argument"))
}
\arguments{
\item{object}{an object with the result of the fitted elliptical regression model.}

\item{...}{arguments to be used to form the default control argument if it is not supplied directly.}

\item{df}{degrees of freedom.}

\item{k}{shape parameter.}

\item{parma}{parameter vector (alpha, m).}

\item{parm}{parameter vector (s, r) for this distribuition.}

\item{parmt}{parameters vector (epsi, sigma).}

\item{nu}{degrees of freedom.}
}
\value{
An object of class \dQuote{family} specifying a list with the follows elements:
\item{family}{character: the family name.}
\item{g0, g1, g2, g3, g4, g5}{derived fuctions associated with the distribution family defined.}
\item{df}{degree of freedom for t-Student distribution.}
\item{s, r}{shape parameters for generalized t-Student distribution.}
\item{alpha}{shape parameter for contaminated normal and generalized logistic distributions.}
\item{mp}{shape parameter for generalized logistic distribution.}
\item{epsi,sigmap}{dispersion parameters for contaminated normal distribution.}
\item{k}{shape parameter for power exponential distribution.}

a famility elliptical object using a Normal distribution.

a famility elliptical object using a Couchy distribution.

a famility elliptical object using a LogisI distribution.

a famility elliptical object using a LogisII distribution.

a famility elliptical object using a Student distribution with a specific degrees of freedom.

a famility elliptical object using an exponential distribution.

a famility elliptical object using a Glogis distribution.

a famility elliptical object using a Gstudent distribution.

a famility elliptical object using a Cnormal distribution

a famility elliptical object using a Gnormal distribution
}
\description{
The family object provide an specify details of the model APLMS. The distribution functions are necessary to specify the random component of the regression models with elliptical errors. The code is derived from the archived package \pkg{gwer} (Araujo, Y.A., Cysneiros, F.J.A., and Cysneiros, A.H.M.A., 2022), originally available on CRAN.
}
\examples{
Normal()
Powerexp(k=0.1)
}
\references{
Fang, K. T., Kotz, S. and NG, K. W. (1990, ISBN:9781315897943).
Symmetric Multivariate and Related Distributions. London: Chapman and Hall.
}
\keyword{Elliptical}
\keyword{distributions}
