% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perform_hypothesis_test.R
\name{get.quantile.gupta.selection}
\alias{get.quantile.gupta.selection}
\title{Generate the quantile used for the selection procedure in \insertCite{gupta.1965}{argminCS}.}
\usage{
get.quantile.gupta.selection(p, alpha = 0.05, N = 1e+05)
}
\arguments{
\item{p}{The number of dimensions in your data matrix.}

\item{alpha}{The level of the upper quantile; defaults to 0.05 (95\% percentile).}

\item{N}{The number of Monte Carlo repetitions; defaults to 100000.}
}
\value{
A list containing:\tabular{ll}{
   \code{critica.val} \tab The 1 - alpha upper quantile. \cr
}
}
\description{
Generate the quantile used for the selection procedure in \insertCite{gupta.1965}{argminCS} by Monte Carlo estimation.
}
\note{
The quantile is pre-calculated for some common configurations of (p, alpha)
}
\examples{
get.quantile.gupta.selection(p=10)

get.quantile.gupta.selection(p=100)

}
\references{
\insertRef{gupta.1965}{argminCS}

\insertRef{futschik.1995}{argminCS}
}
