% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arrg.R
\name{arrg}
\alias{arrg}
\title{Create an argument parser}
\usage{
arrg(name, ..., patterns = list(), header = NULL, footer = NULL)
}
\arguments{
\item{name}{The name of the command.}

\item{...}{Option specifications. See \code{\link[=opt]{opt()}} for details.}

\item{patterns}{A list of usage patterns that are valid for the command,
each specifying acceptable options and positional arguments. See \code{\link[=pat]{pat()}}
for details.}

\item{header, footer}{Optional paragraphs of text to be prepended and/or
appended to the usage text produced by the \code{show} method of the return
value. Typically used to introduce the command or give brief guidance on
usage.}
}
\value{
A list with function elements
\itemize{
\item \code{parse(args)}: Parse the character vector of arguments passed in, or by
default, the value of \code{commandArgs(trailingOnly=TRUE)}.
\item \code{show(con, width)}: Print a usage summary, detailing the valid options and
patterns. Text will be printed to the specified connection, default
\code{\link[=stdout]{stdout()}}, and wrapped to the width given, which defaults to the value of
the standard \code{width} option.
}
}
\description{
This function creates an argument parser that handles the specified options
and usage patterns. To parse arguments or display usage information, the
methods \code{parse} or \code{show} contained in the return value should be
called.
}
\examples{
  # A simple parser for a command called "test" with only one option, -h
  p <- arrg("test", opt("h", "Print help"), patterns=list(pat(options="h!")))
  
  # Print out usage information
  p$show()
  
  # Parse the option
  p$parse("-h")
}
\seealso{
\code{\link[=opt]{opt()}}, \code{\link[=pat]{pat()}}
}
\author{
Jon Clayden
}
