% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bandsolve.R
\name{rot2mat}
\alias{rot2mat}
\title{Get back a symmetric square matrix based on his rotated row-wised version.}
\usage{
rot2mat(R)
}
\arguments{
\item{R}{Rotated matrix.}
}
\value{
Band square matrix.
}
\description{
Get back a symmetric square matrix based on his rotated row-wised version.
The rotated form of the input is such each column correspond to a diagonal, where the first column is the main diagonal and next ones are the upper/lower-diagonal.
To match dimension, last element of these columns are discarded.
}
\examples{

D0 = 1:5;
D1 = c(0,1,0,0);
D2 = rep(2,3);

A = rot2mat(cbind(D0,c(D1,0),c(D2,0,0)))
A
mat2rot(rot2mat(cbind(D0,c(D1,0),c(D2,0,0))))

}
