% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci.R
\name{ci}
\alias{ci}
\title{Calculate a confidence interval for an attenuated correlation coefficient.}
\usage{
ci(r, N, level = 0.95, method = "corr", k = NULL)
}
\arguments{
\item{r}{Numeric vector of three elements in [-1,1]. \code{r[1]} is the
correlation between the noisy measures X' and Y', \code{r[2]} is the
correlation between the noisy X' and the true X, while \code{r[3]} is
the correlation between the noisy Y' and the true Y.}

\item{N}{Numeric vector of three positive integers. \code{N[i]} is the
sample size for \code{r[i]}.}

\item{level}{Numeric in [0, 1]. Confidence level of the interval. Defaults to
0.95.}

\item{method}{The type of confidence curve. Can be \code{"corr"},
\code{"cronbach"}, \code{"HS"} or \code{"free"}. See the details of
\code{\link{p_value}}.}

\item{k}{Numeric vector of two positive integers. \code{k[i]} is the number
of testlets for the for \code{r[i+1]}. Only needed for method
\code{"cronbach"}.}
}
\value{
Numeric in [0, 1]. The p-value under null-hypothesis rho.
}
\description{
Calculate a confidence interval for an attenuated correlation coefficient.
}
\examples{
    r = c(0.20, sqrt(0.45), sqrt(0.55))
    N = c(100, 100, 100)
    ci(r, N) # Calculates 95\% confidence set for rho.
}
