% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_tandem_seq_from_tandem_id.R
\name{get_tandem_seq_from_tandem_id}
\alias{get_tandem_seq_from_tandem_id}
\title{Get the tandem repeat sequence from tandem repeat}
\usage{
get_tandem_seq_from_tandem_id(
  tandem_id,
  seed_id = FALSE,
  genome_id = FALSE,
  tandem_pos = FALSE,
  triplestore
)
}
\arguments{
\item{tandem_id}{Integer or a list of integer values.}

\item{seed_id}{Integer (from 1 to 1000), a vector of integer
values, or a logical value. This integer is used for starting the
pseudo-random number generator that represents the environment experiencing a
digital organism. If a logical value is used, TRUE returns data found in all
environments and FALSE (by default) returns only distinct data regardless of
the seed.}

\item{genome_id}{Logical value (TRUE/FALSE) to show/hide this column
(FALSE by default).}

\item{tandem_pos}{Logical value (TRUE/FALSE) to show/hide this column
(FALSE by default).}

\item{triplestore}{Object of class triplestore_access which manages database
access.}
}
\value{
Data frame. Columns: "seed_id" (optional), "tandem_id", "tandem_seq",
"tandem_pos" (optional), genome_id" (optional).
}
\description{
Get the tandem sequence from the tandem repeat contained in the
transcriptome of a digital organism for a list of seeds used for starting
the pseudo-random number generator (i.e., a set of environments).
}
\examples{

# Create triplestore object
avidaDB <- triplestore_access$new()

# Set access options
avidaDB$set_access_options(
  url = "https://graphdb.fortunalab.org",
  user = "public_avida",
  password = "public_avida",
  repository = "avidaDB_test"
)

# Single tandem
get_tandem_seq_from_tandem_id(
  tandem_id = 6336945,
  triplestore = avidaDB
)

# More than one tandem at seed_1
get_tandem_seq_from_tandem_id(
  tandem_id = c(6336945, 2520963, 2520963),
  seed_id = 1,
  triplestore = avidaDB
)

# At seed_3 and seed_5
get_tandem_seq_from_tandem_id(
  tandem_id = 6336945,
  seed_id = c(1, 3),
  tandem_pos = TRUE,
  genome_id = TRUE,
  triplestore = avidaDB
)

}
