% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_access.R
\name{triplestore_access}
\alias{triplestore_access}
\title{Class to manage triplestore access options}
\description{
Class to manage triplestore access options
}
\examples{

# Create object triplestore

triplestore <- triplestore_access$new()


# Set options to access a specific triple-store implemented in GraphDB

triplestore$set_access_options(
  url = "https://graphdb.fortunalab.org",
  user = "public_avida",
  password = "public_avida",
  repository = "avidaDB_test"
)


# Show current access options

triplestore$get_access_options()


# Querying data with SPARQL

triplestore$submit_query('PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>
                          PREFIX xsd: <http://www.w3.org/2001/XMLSchema#>
                          select ?tandem_id where { 
                            ?digital_tandem_repeat rdfs:label "digital tandem repeat"@en .
                            ?tandem_id a ?digital_tandem_repeat .
                          } limit 10')


# Show ontology info

triplestore$ontology()


}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-triplestore_access-new}{\code{triplestore_access$new()}}
\item \href{#method-triplestore_access-get_access_options}{\code{triplestore_access$get_access_options()}}
\item \href{#method-triplestore_access-set_access_options}{\code{triplestore_access$set_access_options()}}
\item \href{#method-triplestore_access-submit_query}{\code{triplestore_access$submit_query()}}
\item \href{#method-triplestore_access-ontology}{\code{triplestore_access$ontology()}}
\item \href{#method-triplestore_access-clone}{\code{triplestore_access$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-triplestore_access-new"></a>}}
\if{latex}{\out{\hypertarget{method-triplestore_access-new}{}}}
\subsection{Method \code{new()}}{
Create and initialize the object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{triplestore_access$new()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Object of class triplestore_access.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-triplestore_access-get_access_options"></a>}}
\if{latex}{\out{\hypertarget{method-triplestore_access-get_access_options}{}}}
\subsection{Method \code{get_access_options()}}{
Get access options
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{triplestore_access$get_access_options()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
list containing URL of the API server, user credentials,
repository name, authentication status, and SPARQL protocol version
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-triplestore_access-set_access_options"></a>}}
\if{latex}{\out{\hypertarget{method-triplestore_access-set_access_options}{}}}
\subsection{Method \code{set_access_options()}}{
Set authentication access options for graphdb triplestore
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{triplestore_access$set_access_options(
  url = NULL,
  user = NULL,
  password = NULL,
  repository = NULL,
  timeout = 100
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{url}}{String containing the URL of the triplestore server}

\item{\code{user}}{String containing the username if authentication is needed}

\item{\code{password}}{String containing the password if authentication is needed}

\item{\code{repository}}{String containing the ID of the repository to which you want to connect to}

\item{\code{timeout}}{Connection timeout limit in seconds used for queries}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-triplestore_access-submit_query"></a>}}
\if{latex}{\out{\hypertarget{method-triplestore_access-submit_query}{}}}
\subsection{Method \code{submit_query()}}{
Submit a SPARQL query to the triplestore to obtain data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{triplestore_access$submit_query(query)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{query}}{String containing the SPARQL query to retrieve data}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-triplestore_access-ontology"></a>}}
\if{latex}{\out{\hypertarget{method-triplestore_access-ontology}{}}}
\subsection{Method \code{ontology()}}{
Show ontology information
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{triplestore_access$ontology()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
List containing title, description and versionIRI of the ontology
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-triplestore_access-clone"></a>}}
\if{latex}{\out{\hypertarget{method-triplestore_access-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{triplestore_access$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
